package gov.va.vinci.dart.db.impl;

import java.sql.ResultSet;
import java.sql.SQLException;

import gov.va.vinci.dart.biz.Group;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.biz.RequestSummary;
import gov.va.vinci.dart.biz.WorkflowSummary;

public class RequestSummaryBuilderForIrma {

//TODO: verify that we don't show requests that haven't been submitted in the NDS review queue -> need to handle dirty data from the old SharePoint system where requests have no submitted timestamp, but they've been approved.
	public RequestSummary build(final ResultSet rs) throws SQLException {
		
		RequestSummary result = new RequestSummary();
		WorkflowSummary workflowSummary = new WorkflowSummary();
		
		result.setRequestId(rs.getInt(3));
		result.setActivityId(rs.getInt(2));
		result.setTrackingNumber(rs.getString(4));

		try {
			workflowSummary.setWorkflowId(rs.getInt(21));
		} catch( Exception exc ) {
			workflowSummary.setWorkflowId(0);	//legacy data
		}

		rs.getInt(22);
		if( rs.wasNull() == true ) {
			workflowSummary.setWorkflowTemplateId(0);	//default to workflowTemplateId = 0
		} else { 
			workflowSummary.setWorkflowTemplateId(rs.getInt(22));
		}
		
		rs.getInt(24);
		if( rs.wasNull() == true ) {
			Group.initialize();
			workflowSummary.setWorkflowGroupId(Group.NDS.getId());	//default to NDS (legacy data)
		} else {
			workflowSummary.setWorkflowGroupId(rs.getInt(24));	//top-level group
		}


		rs.getString(5);
		if (rs.wasNull()) {
			result.setActivityName(rs.getString(6));
		} else if (rs.getString(5).trim().length() == 0) {
			result.setActivityName(rs.getString(6));
		} else {
			result.setActivityName(rs.getString(5));
		}

		
		rs.getDate(8);
		if( rs.wasNull() == false ) {
			result.setSubmittedOn( rs.getDate(8) );
		} else {
			result.setSubmittedOn( rs.getDate(7) );
		}
		
		result.setUpdatedOn(rs.getTimestamp(9));
		

		
		//not currently used (part of the elaborate status)
		result.setTotalReviews(rs.getInt(11));
		result.setCompletedReviews(rs.getInt(12));

		result.setType(rs.getInt(10));
		
		//result.setStatus(rs.getInt(1));
		workflowSummary.setStatus(rs.getInt(23));	//overall workflow status
		
		rs.getString(13);
		if( rs.wasNull() == false) {
			result.setPrincipalInvestigatorName(rs.getString(13));	//Fullname
			result.setRetrievedPrincipalInvestigatorName(true);
		}

		//not currently used
		rs.getInt(17);
		if (rs.wasNull() == false) {
			result.setDaysElapsed(rs.getInt(17));	// FinalEventTimeDiffInDays - need to append a 'days'
		}
		
		workflowSummary.setRequestState(rs.getString(14));	//includes the "elaborate status" for this request
		
		result.setRequestType(rs.getString(18));
	    //TODO:  PII - Clean this up after testing
        if (result.getRequestType() != null) {
            if (result.getRequestType().equals(Request.DATA_ACCESS)) {
                result.setResearchRequest(true);
            } else if (result.getRequestType().equals(Request.PREPARATORY_TO_RESEARCH_ACCESS)) {
                result.setPreparatoryRequest(true);
            } else if (result.getRequestType().equals(Request.OPERATIONS_DATA_ACCESS)) {
                result.setOperationsRequest(true);
            }
        }
		
		int isResearch = rs.getInt(19);


		int isEditable = rs.getInt(15);
		if (isEditable == 1) {
			result.setEditable(true);						
		}
	
		int isAmendable = rs.getInt(16);
		if (isAmendable == 1) {
			result.setAmendable(true);
		}
		
		result.getWorkflowSummaryList().add( workflowSummary );
		return result;
	}
}
